﻿* Encoding: UTF-8.
*==============================================================================*.
* TÍTULO DE LA SINTAXIS:							   
* Cálculo de indicadores de la nueva condición de actividad		y sectorización de la PEA	   				   
* OPERACIÓN ESTADÍSTICA:													   
* Encuesta Nacional de Empleo, Desempleo y Subempleo (ENEMDU)				   
* UNIDAD TÉCNICA RESPONSABLE: 												   
* Dirección de Estadísticas Sociodemográficas (DIES)						   
* ENTIDAD EJECUTORA:														   
* Instituto Nacional de Estadística y Censos (INEC)							   
*==============================================================================*.
* Fecha de elaboración:          Septiembre - 2014							   
* Fecha última modificación:   Junio - 2019					   
*==============================================================================*.
* Sintaxis elaborada en base a la "Nota metodológica para la medición del empleo en Ecuador".
*==============================================================================*.
* Elaborado por:													   
* Dirección de Estadísticas Sociodemográficas (DIES)						   
* Gestión de Estadísticas Permanentes a Hogares 	   						   
* Aprobado por:													   
* Dirección de Estudios Laborales y Económicos (DELE)				       
* Unidad de Estudios de Mercado Laboral								       
*==============================================================================*.
* Revisado por:																   
* 1. Dirección de Estudios Laborales y Económicos (DELE)				       
*    Unidad de Estudios de Mercado Laboral								       
* 2. Dirección de Estadísticas Sociodemográficas (DIES)						   
*    Gestión de Estadísticas Permanentes a Hogares 	   						   
*==============================================================================*.
*Indicaciones.
*1- Ejecute esta sintaxis en la base de datos: 201906_EnemduBDD_15anios

*==============================================================================*.
*VARIABLES PARA DE TRABAJO PARA GENERACIÓN DE TABULADOS DE MERCADO LABORAL
*==============================================================================*.
*=============================.
*Provincias*.
*=============================.
string ciudad(a6).
compute ciudad=substr(upm,1,6).
exe.

*=============================.
* Ciudades Autorepresntadas (cinco) *.
*=============================.
alter type area(f1.0) ciudad(f6.0).
output close *. 
if (ciudad =170150 and area=1) dom_ciu = 1.
if (ciudad =90150 and area=1) dom_ciu = 2.
if (ciudad =10150 and area=1) dom_ciu = 3.
if (ciudad =180150 and area=1) dom_ciu = 5.
if (ciudad =70150 and area=1) dom_ciu =4.
val lab dom_ciu 1'Quito' 2'Guayaquil' 3'Cuenca' 5'Ambato' 4'Machala'.
var lab dom_ciu 'Ciudades'.
exe.

*=============================================.
compute t=1.
var lab t 'Poblacion Total'.
*=============================================.
*Generación de Indicadores de Mercado Laboral - Tasas.
*=============================================.
if( petn=1) templeob=0.
if (empleo=1) templeob=100.
if (pean=1) templeog=0.
if (empleo=1) templeog=100.
if (pean=1) tadec=0.
if (adec=1) tadec=100.
if( pean=1) tsub=0.
if (sub=1) tsub=100.
if( pean=1) tsub_h=0.
if (sub_h=1) tsub_h=100.
if( pean=1) tsub_w=0.
if (sub_w=1) tsub_w=100.
if ( pean=1) toinad=0.
if (oinad=1) toinad=100.
if( pean=1) tnr=0.
if (nr=1) tnr=100.
if( pean=1) tnc=0.
if (nc=1) tnc=100.
if( pean=1) tdesem=0.
if (desem=1) tdesem=100.
if( pean=1) tdesemab=0.
if (desemab=1) tdesemab=100.
if( pean=1) tdesemoc=0.
if (desemoc=1) tdesemoc=100.
if( pean=1) tdesem1=0.
if (desem1=1) tdesem1=100.
if( pean=1) tdesem2=0.
if (desem2=1) tdesem2=100.
if( t_a=1) tpartib15=0.
if (pean=1 and p03>=15) tpartib15=100.
if( petn=1) tpartig=0.
if (pean=1 and p03>=15) tpartig=100.
if( pean=1) tsubu=0.
if (sub=1 or desem=1) tsubu=100.
exe.

*============================. 
*Empleado público y privado.
*============================.
*Esta variable incluye a los trabajadores domésticos 
para la población de empleados provados.
RECODE P42 (1 = 1) (2 THRU 10=2) INTO claempl.
var label claempl 'Tipó de Empleador'.
value label claempl
1'Empleado Público'
2'Empleado Privado'.
var lev claempl (NOMINAL).
exe.

*============================. 
*.Asalariado e Independiente
*============================.
recode P42 (1 THRU 4= 1) (10= 1) (5 THRU 6 =2) INTO asalind.
var label asalind 'Tipo de Trabajo'.
value label asalind
1'Empleado Asalariado'
2'Empleado Independiente'.
var lev claempl (NOMINAL).
EXE.

*============================. 
*Nivel de instrucción.
*============================.
if(p10a=1) nnivins=1.
if(p10a=2) nnivins=2.
if(p10a=3 or p10a=4 or p10a=5 or p10a=6 and p10b<4) nnivins=3.
if(p10a=7 or p10a=8 or p10a=6 and p10b>3) nnivins=4.
if( p10a>=8 and p10a<=10) nnivins=5.

var label nnivins'nnivins. Nivel de instrucción'.
val label nnivins
1'Ninguno'
2'Centro de Alfabetización'
3'Educación Básica'
4'Educación Media/Bachillerato'
5'Superior'.

*============================.
*Horas de trabajo.
*============================.
recode p51a p51b (999=sysmis).
compute ht=sum(p51a,p51b).

*============================.
*Tiempo de trabajo*.
*============================.
recode p45(99=sysmis).
recode p45 (0 =1)  (1 thru 10=2)  (11 thru 29=3) (30 THRU HIGHEST=4) INTO AT.
var lab at'Tiempo de Trabajo'.
exe.
val lab AT 1'Menos de 1 año'
2'De 1 a 10 años'
3'De 11 a 29 años'
4'30 y más '.

*=======================.
*Grupos étnicos
*=======================.
recode p15(1=1) (2=2)(3=2)(4=2)(5=5) (6=3) (7=4) (8=6) into etnia.
var lab etnia 'Etnia'.
val lab etnia 1'Indigena' 2'Afroecuatoriano'   3'Mestizo/a' 4'Blanco' 5'Montubio' 6'Otro Cuál?'.
exe.
var lev etnia (NOMINAL).

*========================. 
*Tiempo de Búsqueda de Trabajo
*============================.
recode p33 (999=SYSMIS).
recode p33 (0 thru 4=1) (5 thru 8=2)(9 thru 24=3)(25 thru HIGHEST=4) into tbt.
val lab tbt 1'Hasta un mes'
2'Entre 1 y dos meses'
3'Entre 2 y seis meses'
4'6 meses y más.'.

*=============================================.
*Seguridad Social.
*=============================================.
compute seguro =$sysmis.
if (p05a=1 or p05b=1) seguro=1.
if (p05a>=2 and p05a<=9) seguro=2.
if (p05a=10) seguro=3.
val label seguro 
1'IESS - Seguro General' 
2'Otro Seguro - No IESS Seguro General' 
3'Ninguno'.
exe.

*============================. 
*Horas Efectivas.
*============================.
recode p24(999=sysmis).
exe.
*============================.
*Rama de actividad_3 - (15 categorías)*.
*============================.
recode rama1 (1=1)(2=2)(3=3)(4=4)(8=8) (5=4)(6=5)(7=6)(9=7)(10=9)(11=10)(13 thru 14=11)(15=13)(16 thru 17=12)(12=15) (18 thru 19=15) (21 thru 22=15) (20=14) (9999=15) into rama3.
val lab rama3
1 'Agricultura, ganadería, caza y silvicultura y pesca' 
2 'Petróleo y minas' 
3 'Manufactura (incluida refinación de petróleo)' 
4 'Suministro de electricidad y agua' 
5 'Construcción' 
6 'Comercio' 
7 'Alojamiento y servicios de comida' 
8 'Transporte' 
9 'Correo y Comunicaciones' 
10 'Actividades de servicios financieros' 
11 'Actividades profesionales, técnicas y administrativas' 
12 'Enseñanza  y Servicios sociales y de salud' 
13 'Administración pública, defensa; planes de seguridad social obligatoria' 
14 'Servicio doméstico'
15 'Otros Servicios'.
exe.

*=======================.
*Grupos de edad*.
*=======================.
recode p03 (15 thru 24=1) (25 thru 34=2) (35 thru 44=3) (45 thru 64=4) (65 thru HIGHEST=5) into gedad.
var lab gedad 'grupos de edad'.
val lab gedad
1'Poblacion 15-24 años'
2'Poblacion  25-34 años'
3'Poblacion de 35-44 años'
4'Poblacion de 45-64 años'
5'Poblacion de 65 años y más'.
exe.

*=======================================.
*Sectorización de la población empleada*.
*=======================================.
if formal=1 secto=1.
if informal=1 secto=2.
if empdom=1 secto=3.
if nocla=1 secto=4.
var lab secto 'Sectorizacion de la PEA'.
val  lab secto
1'Población con empleo en el sector formal'
2'Población con empleo en el sector informal'
3'Población con empleo Doméstico'
4'Población con empleo no clasificado por sector'.
exe.

*=======================================.
*Ingreso laboral, deflactado, de la población empleada*.
*=======================================.

compute inglab=ingrl.
recode inglab(-1 =SYSMIS) (999999=SYSMIS).
*cambiar IPC segun el periodo para Junio-2019 actualizar con Mayo-2019.
compute ipc_=105.48.
compute defla=(73.40/ipc_).
compute ing_defla=(inglab*defla).
exe.

*=========================.
*Sector Informal.
*=========================.

if empleo=1 tinformal=0.
if informal=1 tinformal=100.
exe.

*=========================.
*Filtros.
*=========================.
IF ((area=1 or area=2 ) ) fil00=1.
if area=1   fil01=1.
if area=2  fil02=1.
exe.
var lab fil00'Nacional'
/fil01'Urbano' 
/fil02'Rural'.

*=========================.
*Periodo de la ronda.
*=========================.

*La variable año contiene el periodo o ronda al que se 
refiere la encuesta.
compute año=201906.
val lab año 201906 'jun-2019'.
exe.

*=========================.
*Sectorización de la PEA.
*=========================.

if formal=1 secto=1.
if informal=1 secto=2.
if empdom=1 secto=3.
if nocla=1 secto=4.
var lab secto 'sectorizacion pean'.
val lab secto
1'Población con empleo en el sector formal'
2'Población con empleo en el sector informal'
3'Población con empleo Doméstico'
4'Población con empleo no clasificado por sector'.
exe.

*=========================.
*Caracterización de los desempleados.
*=========================.
if desem1=1 desemb=1.
if desem2=1 desemb=2.
if desemab=1 desema=1.
if desemoc=1 desema=2.
exe.
var lab desema 'Según busqueda de empleo'.
var lab desemb 'Según experiencia previa'.
val lab desemb 1'Cesante' 2'Nuevo'.
val lab desema 1'Desempleo abierto' 2'Desempleo oculto'.


